//
//  cffDict.h
//  GSFontTools
//
//  Created by Georg Seifert on 01.08.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
@class CFFIndexedStrings;
@class CFFGlobalSubrsIndex;
@class GSXMLWriter;
@class GSFileData;

@interface CFFBaseDict : NSObject {
	NSMutableDictionary *_dict;
	NSDictionary *_defaults;
	NSDictionary *_converters;
	NSArray *_order;
	NSDictionary *_decompilerClass;
	NSDictionary *_compilerClass;

	GSFileData *_file;
	NSMutableDictionary *_rawDict;
	NSUInteger _offset;
	CFFIndexedStrings *_strings;
	CFFGlobalSubrsIndex *_globalSubrs;
	NSArray *_charset;
}

@property (retain, nonatomic) GSFileData *file;
@property (retain, nonatomic) NSArray *charset;
@property (readonly, nonatomic) CFFIndexedStrings *strings;
@property (nonatomic, retain) CFFGlobalSubrsIndex *globalSubrs;
@property (nonatomic) NSUInteger offset;
@property (nonatomic, readonly) NSDictionary *rawDict;
@property (strong) NSArray *skipNames;

- (id)initWithStrings:(CFFIndexedStrings *)Strings file:(GSFileData *)File offset:(NSUInteger)Offset;

- (id)initWithStrings:(CFFIndexedStrings *)Strings file:(GSFileData *)File offset:(NSUInteger)Offset globalSubrs:(CFFGlobalSubrsIndex *)GlobalSubrs;

- (Class)decompilerClass;

- (Class)compilerClass;

- (void)decompile:(NSData *)Data;

- (void)postDecompile;

- (id)defaults;

- (void)toXML:(GSXMLWriter *)Writer;

- (void)fromXML:(NSString *)name attrs:(NSDictionary *)attrs content:(id)content;
@end

@interface CFFTopDict : CFFBaseDict {
	NSUInteger _numGlyphs;
	id _charStrings;
}

@property (readonly, nonatomic) NSUInteger numGlyphs;
@property (readonly, nonatomic) id charStrings;

- (NSArray *)glyphOrder;
@end

@interface CFFFontDict : CFFBaseDict
@end

@interface CFFPrivateDict : CFFBaseDict
@end
